<?php
require 'vendor/autoload.php';

use Stichoza\GoogleTranslate\GoogleTranslate;
function translateControllers($directory) {
    $tr = new GoogleTranslate('pt-BR');
    $items = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
    foreach ($items as $item) {
        if ($item->isFile() && pathinfo($item, PATHINFO_EXTENSION) === 'php') {
            $filePath = $item->getPathname();
            $content = file_get_contents($filePath);
            $pattern = '/translate\(\'(.*?)\'\)/';

            $newContent = preg_replace_callback($pattern, function ($matches) use ($tr) {
                $translated = $tr->translate($matches[1]);
                return "translate('{$translated}')";
            }, $content);
            if ($newContent !== $content) {
                file_put_contents($filePath, $newContent);
                echo "Arquivo {$filePath} traduzido com sucesso.\n";
            }
        }
    }
}
$directory = __DIR__ . '/app/Http/Controllers';
translateControllers($directory);
