

<?php $__env->startSection('meta_title'); ?><?php echo e($blog->meta_title); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta_description'); ?><?php echo e($blog->meta_description); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta_keywords'); ?><?php echo e($blog->meta_keywords); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="<?php echo e(static_asset('assets/css/blog.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="<?php echo e($blog->meta_title); ?>">
    <meta itemprop="description" content="<?php echo e($blog->meta_description); ?>">
    <meta itemprop="image" content="<?php echo e(uploaded_asset($blog->meta_img)); ?>">

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="<?php echo e($blog->meta_title); ?>">
    <meta name="twitter:description" content="<?php echo e($blog->meta_description); ?>">
    <meta name="twitter:creator" content="@author_handle">
    <meta name="twitter:image" content="<?php echo e(uploaded_asset($blog->meta_img)); ?>">

    <!-- Open Graph data -->
    <meta property="og:title" content="<?php echo e($blog->meta_title); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="<?php echo e(route('blog.details', $blog->slug)); ?>" />
    <meta property="og:image" content="<?php echo e(uploaded_asset($blog->meta_img)); ?>" />
    <meta property="og:description" content="<?php echo e($blog->meta_description); ?>" />
    <meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="wrapper">
    <main class="main-content site-wrapper-reveal bgcolor-gray">
      <section class="blog-details-area">
        <div class="container-fluid p-0 new_image">
          <img class="w-100" src="<?php echo e(uploaded_asset($blog->banner)); ?>" alt="<?php echo e($blog->title); ?>">
        </div>
        <div class="container pt-0 pb-150 pb-md-80 ">
          <div class="post-details-content post-content-style3 pb-md-50 shadow">
            <div class="row">
              <div class="col-lg-8 m-auto">
                <div class="post-details-body post-body-style2">
                  <div class="content">
                    <div class="bread-crumbs text-theme-color5 lh-1 mb-70 mb-sm-40">
                      <a href="<?php echo e(route('home')); ?>">Home /</a> <a href="<?php echo e(route('blog')); ?>">Blog </a> 
                    </div>
                    <h2 class="title mb-10 pb-2"><?php echo e($blog->title); ?></h2>
                    <?php echo $blog->description; ?>

                  </div>
                </div>
                <div class="related-posts">
                  <h2 class="title"><?php echo e(translate('Postagens recentes')); ?></h2>
                  <div class="post-items-slider-four row">
                    <?php $__currentLoopData = $recent_blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent_blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-6">
                        <div class="post-item card">
                          <div class="thumb">
                            <a href="<?php echo e(url("blog").'/'. $recent_blog->slug); ?>"><img src="<?php echo e(uploaded_asset($recent_blog->banner)); ?>" alt="<?php echo e($recent_blog->title); ?>"></a>
                          </div>
                          <div class="content">
                            <h4 class="title">
                              <a href="<?php echo e(url("blog").'/'. $recent_blog->slug); ?>"><?php echo e($recent_blog->title); ?></a>
                            </h4>
                            <div class="meta bottom">
                              <div>
                                Por
                                <span class="author"><?php echo e(get_setting('website_name')); ?></span>
                                <span><?php echo e(date('d M Y',strtotime($recent_blog->created_at))); ?></span>
                              </div>
                            </div>
                          </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="line-hr"></div>
      </section>
    </main>
  </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php if(get_setting('facebook_comment') == 1): ?>
        <div id="fb-root"></div>
        <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v9.0&appId=<?php echo e(env('FACEBOOK_APP_ID')); ?>&autoLogAppEvents=1" nonce="ji6tXwgZ"></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hoogli/samambaia.hoogli.partners/resources/views/frontend/blog/details.blade.php ENDPATH**/ ?>