

<?php $__env->startSection('content'); ?>
<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h1 class="h3"><?php echo e(translate('Todas as categorias de blog')); ?></h1>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_blog_category')): ?>
            <div class="col-md-6 text-md-right">
                <a href="<?php echo e(url('admin/blog-category/create')); ?>" class="btn btn-circle btn-info">
                    <span><?php echo e(translate('Adicionar nova categoria')); ?></span>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<div class="card">
    <div class="card-header d-block d-md-flex">
        <h5 class="mb-0 h6"><?php echo e(translate('Categorias de blogs')); ?></h5>
        <form class="" id="sort_categories" action="" method="GET">
            <div class="box-inline pad-rgt pull-left">
                <div class="" style="min-width: 200px;">
                    <input type="text" class="form-control" id="search" name="search"<?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?> placeholder="<?php echo e(translate('Digite o nome e digite')); ?>">
                </div>
            </div>
        </form>
    </div>
    <div class="card-body">
        <table class="table aiz-table mb-0">
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th><?php echo e(translate('Nome')); ?></th>
                    <th width="10%" class="text-right"><?php echo e(translate('Opções')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(($key+1) + ($categories->currentPage() - 1)*$categories->perPage()); ?></td>
                    <td><?php echo e($category->category_name); ?></td>
                    <td class="text-right">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_blog_category')): ?>
                            <a class="btn btn-soft-primary btn-icon btn-circle btn-sm" href="<?php echo e(url('admin/blog-category/'.$category->id.'/edit')); ?>" title="<?php echo e(translate('Editar')); ?>">
                                <i class="las la-edit"></i>
                            </a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_blog_category')): ?>
                            <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" data-href="<?php echo e(route('blog-category.destroy', $category->id)); ?>" title="<?php echo e(translate('Excluir')); ?>">
                                <i class="las la-trash"></i>
                            </a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div class="aiz-pagination">
            <?php echo e($categories->appends(request()->input())->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('modal'); ?>
<?php echo $__env->make('modals.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hooglicl/topazio.hoogli.cloud/resources/views/backend/blog_system/category/index.blade.php ENDPATH**/ ?>