

<?php $__env->startSection('content'); ?>

<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class="row align-items-center">
        <div class="col-auto">
            <h1 class="h3"><?php echo e(translate('Todas os serviços')); ?></h1>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_blog')): ?>
        <div class="col text-right">
            <a href="<?php echo e(route('exame.create')); ?>" class="btn btn-circle btn-info">
                <span><?php echo e(translate('Adicionar novo serviço')); ?></span>
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>
<br>

<div class="card">
    <form class="" id="sort_blogs" action="" method="GET">
        <div class="card-header row gutters-5">
            <div class="col text-center text-md-left">
                <h5 class="mb-md-0 h6"><?php echo e(translate('Todas os serviços')); ?></h5>
            </div>

            <div class="col-md-2">
                <div class="form-group mb-0">
                    <input type="text" class="form-control form-control-sm" id="search" name="search" <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?> placeholder="<?php echo e(translate('Digite e entre')); ?>">
                </div>
            </div>
        </div>
    </form>
    <div class="card-body">
        <table class="table mb-0 aiz-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(translate('Título')); ?></th>
                    <th data-breakpoints="lg"><?php echo e(translate('Slug')); ?></th>
                    <th data-breakpoints="lg">Serviço</th>
                    <th data-breakpoints="lg">Destaque</th>
                    <th class="text-right"><?php echo e(translate('Opções')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <?php echo e(($key+1) + ($items->currentPage() - 1) * $items->perPage()); ?>

                    </td>
                    <td>
                        <?php echo e($item->title); ?>

                    </td>
                    <td>
                        <?php echo e($item->slug); ?>

                    </td>
                    <td>
                        <?php echo e($item->categoria == 1 ? 'Especialidade' : ($item->categoria == 2 ? 'Exames' : 'Sem categoria')); ?>

                    </td>

                    <td>
                        <label class="aiz-switch aiz-switch-success mb-0">
                            <input type="checkbox" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('publish_parceiros')): ?> onchange="change_status(this)" <?php endif; ?> value="<?php echo e($item->id); ?>" <?php if($item->status == 1) echo "checked";?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('publish_parceiros')): ?> disabled <?php endif; ?>>
                            <span></span>
                        </label>
                    </td>
                    <td class="text-right">
                        <a class="btn btn-soft-primary btn-icon btn-circle btn-sm" href="<?php echo e(route('exame.edit',$item->id)); ?>" title="<?php echo e(translate('Editar')); ?>">
                            <i class="las la-pen"></i>
                        </a>
                        <a href="<?php echo e(route('exame.duplicate', $item->id)); ?>" class="btn btn-soft-success btn-icon btn-circle btn-sm" title="<?php echo e(translate('Duplicado')); ?>">
                            <i class="las la-copy"></i>
                        </a>
                        <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" data-href="<?php echo e(route('exame.destroy', $item->id)); ?>" title="<?php echo e(translate('Excluir')); ?>">
                            <i class="las la-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div class="aiz-pagination">
            <?php echo e($items->appends(request()->input())->links()); ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php echo $__env->make('modals.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    function change_status(el) {

        var status = 0;
        if (el.checked) {
            var status = 1;
        }
        $.post('<?php echo e(route("exame.change-status")); ?>', {
            _token: '<?php echo e(csrf_token()); ?>'
            , id: el.value
            , status: status
        }, function(data) {
            if (data == 1) {
                AIZ.plugins.notify('success', '<?php echo e(translate("Alterar o status do exame com sucesso")); ?>');
            } else {
                AIZ.plugins.notify('danger', '<?php echo e(translate("Algo deu errado")); ?>');
            }
        });
    }

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hoogli/samambaia.hoogli.partners/resources/views/backend/themes/exameall/clinica/index.blade.php ENDPATH**/ ?>