@extends('frontend.layouts.user_panel')

@section('panel_content')
    <div class="aiz-titlebar mb-4">
      <div class="row align-items-center">
        <div class="col-md-6">
            <h1 class="fs-20 fw-700 text-dark">{{ translate('Adicione seu produto') }}</h1>
        </div>
      </div>
    </div>
    <form class="" action="{{route('customer_products.store')}}" method="POST" enctype="multipart/form-data" id="choice_form">
        @csrf
        <input type="hidden" name="added_by" value="{{ Auth::user()->user_type }}">
        <input type="hidden" name="status" value="available">

        <!-- General -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Em geral')}}</h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Nome do produto')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" class="form-control rounded-0" name="name" placeholder="{{ translate('Nome do produto')}}" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Categoria de produto')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <select class="form-control aiz-selectpicker" data-placeholder="{{ translate('Selecione uma categoria')}}" id="categories" name="category_id" data-live-search="true" required>
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->getTranslation('name') }}</option>
                                @foreach ($category->childrenCategories as $childCategory)
                                    @include('categories.child_category', ['child_category' => $childCategory])
                                @endforeach
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Marca do produto')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <select class="form-control aiz-selectpicker" data-placeholder="{{ translate('Selecione uma marca')}}" data-live-search="true"  id="brands" name="brand_id">
                            <option value=""></option>
                            @foreach (get_all_brands() as $brand)
                                <option value="{{ $brand->id }}">{{ $brand->getTranslation('name') }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Unidade de Produto')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" class="form-control rounded-0" name="unit" placeholder="{{ translate('Unidade de produto')}}" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Doença')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <select class="form-control selectpicker" data-placeholder="{{ translate('Selecione uma condição')}}" id="conditon" name="conditon" required>
                            <option value="new">{{ translate('Novo')}}</option>
                            <option value="used">{{ translate('Usado')}}</option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Localização')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" class="form-control rounded-0" name="location" placeholder="{{ translate('Localização')}}" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{ translate('Etiqueta do produto')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="text" class="form-control aiz-tag-input rounded-0" name="tags[]" placeholder="{{ translate('Digite e aperte enter')}}">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Images -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Imagens')}}</h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Imagens da galeria')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="true">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium rounded-0">{{ translate('Navegar')}}</div>
                            </div>
                            <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                            <input type="hidden" name="photos" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Imagem em miniatura')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <div class="input-group" data-toggle="aizuploader" data-type="image">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium rounded-0">{{ translate('Navegar')}}</div>
                            </div>
                            <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                            <input type="hidden" name="thumbnail_img" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Videos -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Vídeos')}}</h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Vídeo de')}}</label>
                    <div class="col-md-10">
                        <select class="form-control aiz-selectpicker" data-minimum-results-for-search="Infinity" name="video_provider">
                            <option value="youtube">{{ translate('YouTube')}}</option>
                            <option value="dailymotion">{{ translate('Movimento diário')}}</option>
                            <option value="vimeo">{{ translate('Vimeo')}}</option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('URL do vídeo')}}</label>
                    <div class="col-md-10">
                        <input type="text" class="form-control rounded-0" name="video_link" placeholder="{{ translate('Link do vídeo')}}">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Meta Image -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Metatags')}}</h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Metatítulo')}}</label>
                    <div class="col-md-10">
                        <input type="text" name="meta_title" class="form-control rounded-0" placeholder="{{ translate('Metatítulo')}}">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{translate('Descrição')}}</label>
                    <div class="col-md-10">
                        <textarea name="meta_description" rows="8" class="form-control rounded-0"></textarea>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{ translate('Metaimagem')}}</label>
                    <div class="col-md-10">
                        <div class="input-group" data-toggle="aizuploader" data-type="image">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium rounded-0">{{ translate('Navegar')}}</div>
                            </div>
                            <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                            <input type="hidden" name="meta_img" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Price -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Preço')}}</h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{ translate('Preço unitário')}} <span class="text-danger">*</span></label>
                    <div class="col-md-10">
                        <input type="number" lang="en" min="0" step="0.01" class="form-control rounded-0" name="unit_price" placeholder="{{ translate('Preço unitário')}} ({{ translate('Preço Base')}})" required>
                    </div>
                </div>
            </div>
        </div>

        <!-- Description -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Descrição')}} <span class="text-danger">*</span></h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{ translate('Descrição')}}</label>
                    <div class="col-md-10">
                        <div class="mb-3">
                            <textarea class="aiz-text-editor rounded-0" name="description" required></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- PDF Specification -->
        <div class="card rounded-0 shadow-none border">
            <div class="card-header border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{translate('Especificação PDF')}}</h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 col-from-label">{{ translate('PDF')}}</label>
                    <div class="col-md-10">
                        <div class="input-group" data-toggle="aizuploader" data-type="document">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium rounded-0">{{ translate('Navegar')}}</div>
                            </div>
                            <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                            <input type="hidden" name="pdf" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Button -->
        <div class="mar-all text-right">
            <button type="submit" name="button" class="btn btn-primary rounded-0 px-4">{{ translate('Salvar produto') }}</button>
        </div>
    </form>

@endsection

@section('script')
<script type="text/javascript">
    $(document).ready(function() {
        AIZ.plugins.tagify();
    });
</script>
@endsection
