@extends('frontend.layouts.app')

@section('meta_title'){{ $home->meta_title ?? '' }}@stop

@section('meta_description'){{ $home->meta_description ?? '' }}@stop

@section('meta_keywords'){{ $home->meta_keywords ?? '' }}@stop
@section('style')
<style>
</style>
@endsection
@section('content')
@if($homeall->show_section_1 == '1')
<div class="hero-1 sec" id="hero">
    <div class="swiper th-slider hero-slider1" id="heroSlide1" data-slider-options='{"effect":"fade", "autoHeight": "true"}'>
        <div class="swiper-wrapper">
            @if($homeall->carouselOne)
                @foreach (json_decode($homeall->carouselOne, true) as $key => $value)
                    <div class="swiper-slide">
                        <div class="hero-inner" data-mask-src="{{ uploaded_asset($value['img_1']) }}">
                        <div class="th-hero-bg" data-bg-src="{{ uploaded_asset($value['img_2']) }}"></div>
                        <div class="hero-big-text">{{ $value['content_1'] }}</div>
                            <div class="container">
                                <div class="row align-items-center">
                                    <div class="col-lg-8">
                                        <div class="hero-style1">
                                            <h1 class="hero-title text-white">
                                                <span class="title1" data-ani="slideindown" data-ani-delay="0.3s">
                                                    {{ $value['content_2'] }}
                                                </span>
                                                <span class="title2" data-ani="slideindown" data-ani-delay="0.4s">
                                                    {{ $value['content_3'] }}
                                                </span>
                                            </h1>
                                            <p class="hero-text text-white" data-ani="slideinup" data-ani-delay="0.5s">{{ $value['content_4'] }}</p>
                                            <a href="{{ $value['link_1'] }}" class="th-btn btn-mask th-btn-icon" data-ani="slideinup" data-ani-delay="0.6s">{{ $value['link_text_1'] }}</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
        <div class="slider-pagination"></div>
    </div>
    <div class="hero-social-link">
        <div class="social-wrap"> 
            <a aria-label="{!! $homeall->section_1_link_alt_1 !!}">{!! $homeall->section_1_link_conteudo_1 !!}</a> 
            <a href="{{ $homeall->section_1_link_2 }}" aria-label="{!! $homeall->section_1_link_alt_2 !!}">{!! $homeall->section_1_link_conteudo_2 !!}</a> 
            <a aria-label="{!! $homeall->section_1_link_alt_3 !!}">{!! $homeall->section_1_link_conteudo_3 !!}</a> 
        </div>
    </div>
    <div class="scroll-down"> <i class="fal fa-long-arrow-left"></i><a href="{{ $homeall->section_1_link_4 }}" class="hero-scroll-wrap" aria-label="{!! $homeall->section_1_link_alt_4 !!}">{!! $homeall->section_1_link_conteudo_4 !!}</a> </div>
</div>
@endif 
@if($homeall->show_section_2 == '1')
<div class="counter-area-1 bg-smoke sec">
    <div class="container">
        <div class="counter-card-wrap space">
            <div class="counter-card">
                <div class="media-body">
                    <h2 class="box-number"><span class="counter-number">{!! $homeall->section_2_conteudo_5 !!}</span>+</h2>
                    <p class="box-text">{!! $homeall->section_2_conteudo_6 !!}</p>
                </div>
            </div>
            <div class="counter-card">
                <div class="media-body">
                    <h2 class="box-number"><span class="counter-number">{!! $homeall->section_2_conteudo_7 !!}</span>+</h2>
                    <p class="box-text">{!! $homeall->section_2_conteudo_8 !!}</p>
                </div>
            </div>
            <div class="counter-card">
                <div class="media-body">
                    <h2 class="box-number"><span class="counter-number">{!! $homeall->section_2_conteudo_9 !!}</span>k+</h2>
                    <p class="box-text">{!! $homeall->section_2_conteudo_10 !!}</p>
                </div>
            </div>
            <div class="counter-card">
                <div class="media-body">
                    <h2 class="box-number"><span class="counter-number">{!! $homeall->section_2_conteudo_11 !!}</span>k+</h2>
                    <p class="box-text">{!! $homeall->section_2_conteudo_12 !!}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endif @if($homeall->show_section_3 == '1')
<div class="overflow-hidden space-top bg-theme sec" id="about-sec">
    <div class="container">
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-6">
                <div class="title-area"> <span class="shadow-title">{!! $homeall->section_3_conteudo_13 !!}</span>
                    <h2 class="sec-title text-white">{!! $homeall->section_3_conteudo_14 !!}</h2>
                    <p class="sec-text text-white">{!! $homeall->section_3_conteudo_15 !!}</p>
                </div>
            </div>
            <div class="col-lg-auto">
                <div class="sec-btn"> <a href="{{ $homeall->section_3_link_16 }}" class="th-btn btn-mask th-btn-icon" aria-label="{!! $homeall->section_3_link_alt_16 !!}">{!! $homeall->section_3_link_conteudo_16 !!}</a> </div>
            </div>
        </div>
        <div class="row gy-4">
            <div class="col-lg-6">
                <div class="img-box1">
                    <div class="img1 img-shine" data-mask-src="{{ static_asset('themes/clinica/assets/img/shape/about-1-mask.png') }}">{!! $homeall->section_3_conteudo_17 !!}</div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="img-box1">
                    <div class="img1 img-shine" data-mask-src="{{ static_asset('themes/clinica/assets/img/shape/about-1-mask.png') }}">{!! $homeall->section_3_conteudo_18 !!}</div>
                </div>
            </div>
        </div>
        <div class="mt-60">
            <div class="row gy-40 flex-row-reverse">
                <div class="col-xl-3 text-xl-end">
                    <div class="about-tag">
                        <div class="about-experience-tag"> <span class="circle-title-anime">{!! $homeall->section_3_conteudo_19 !!}</span> </div>
                        <div class="about-tag-thumb"> <img class="lazy" src="{{ uploaded_asset($homeall->section_3_img_20) }}" alt="{!! $homeall->section_3_image_alt_20 !!}" loading="lazy"> </div>
                    </div>
                </div>
                <div class="col-xl-9">
                    <div class="about-wrap1">
                        <p class="about-text text-white">{!! $homeall->section_3_conteudo_21 !!}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif @if($homeall->show_section_4 == '1')
<section class="service-area-1 overflow-hidden space-bottom bg-theme pt-80 sec" id="service-sec">
    <div class="container">
        <div class="row gy-40">
            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-card-icon">
                        <div class="icon"> <img class="lazy" src="{{ uploaded_asset($homeall->section_4_img_22) }}" alt="{!! $homeall->section_4_image_alt_22 !!}" loading="lazy"> </div>
                    </div>
                    <div class="box-content">
                        <h3 class="box-title"><a href="{{ $homeall->section_4_link_23 }}" aria-label="{!! $homeall->section_4_link_alt_23 !!}">{!! $homeall->section_4_link_conteudo_23 !!}</a></h3>
                        <p class="box-text">{!! $homeall->section_4_conteudo_24 !!}</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-card-icon">
                        <div class="icon"> <img class="lazy" src="{{ uploaded_asset($homeall->section_4_img_25) }}" alt="{!! $homeall->section_4_image_alt_25 !!}" loading="lazy"> </div>
                    </div>
                    <div class="box-content">
                        <h3 class="box-title"><a href="{{ $homeall->section_4_link_26 }}" aria-label="{!! $homeall->section_4_link_alt_26 !!}">{!! $homeall->section_4_link_conteudo_26 !!}</a></h3>
                        <p class="box-text">{!! $homeall->section_4_conteudo_27 !!}</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-card-icon">
                        <div class="icon"> <img class="lazy" src="{{ uploaded_asset($homeall->section_4_img_28) }}" alt="{!! $homeall->section_4_image_alt_28 !!}" loading="lazy"> </div>
                    </div>
                    <div class="box-content">
                        <h3 class="box-title"><a href="{{ $homeall->section_4_link_29 }}" aria-label="{!! $homeall->section_4_link_alt_29 !!}">{!! $homeall->section_4_link_conteudo_29 !!}</a></h3>
                        <p class="box-text">{!! $homeall->section_4_conteudo_30 !!}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endif @if($homeall->show_section_5 == '1')
<section class="project-area-1 space overflow-hidden bg-smoke" data-bg-src="{{ uploaded_asset($homeall->section_5_img_30 ?? '') }}" data-opacity="5" data-overlay="title">
    <div class="container">
        <div class="project-wrap1">
            <div class="project-number-pagination" data-slider-tab="#projectSlider1">
                @if($homeall->carousel_2)
                    @foreach (json_decode($homeall->carousel_2, true) as $key => $value)
                        <div class="tab-btn @if($key == 0) active @endif"> <span>{{$key + 1}}</span> </div>
                    @endforeach
                @endif
            </div>
            <div class="row gy-50 justify-content-between align-items-center">
                <div class="col-xxl-5 col-xl-6">
                    <div class="project-title-wrap1">
                        <div class="title-area mb-40"> <span class="shadow-title">{!! $homeall->section_5_conteudo_31 !!}</span>
                            <h2 class="sec-title text-white">{!! $homeall->section_5_conteudo_32 !!}</h2>
                            <p class="sec-text text-white mt-15">{!! $homeall->section_5_conteudo_33 !!}</p>
                        </div>
                        <div class="btn-wrap"> <a href="{{ $homeall->section_5_link_34 }}" class="th-btn btn-mask th-btn-icon" aria-label="{!! $homeall->section_5_link_alt_34 !!}">{!! $homeall->section_5_link_conteudo_34 !!}</a> </div>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="slider-area project-slider-area">
                        <div class="swiper th-slider project-slider1" id="projectSlider1" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}},"loop":false, "thumbs":{"swiper":".project-number-pagination"}}'>
                            <div class="swiper-wrapper">
                                @if($homeall->carousel_2)
                                    @foreach (json_decode($homeall->carousel_2, true) as $key => $value)
                                        <div class="swiper-slide">
                                            <div class="portfolio-card">
                                                <div class="portfolio-img img-shine" data-mask-src="{{ uploaded_asset($value['img_1']) }}" data-bs-toggle="modal" data-bs-target="#portfolioModal"> 
                                                    <img src="{{ uploaded_asset($value['img_2']) }}" alt="project image">
                                                    <div class="portfolio-card-shape" data-mask-src="{{ uploaded_asset($value['img_1']) }}"> 
                                                        <img src="{{ uploaded_asset($value['img_3']) }}" alt="img"> 
                                                    </div>
                                                </div>
                                                <div class="portfolio-content"> 
                                                    <a href="#portfolioModal" data-bs-toggle="modal" data-bs-target="#portfolioModal" class="icon-btn">
                                                        <img src="{{ uploaded_asset($value['img_4']) }}" alt="img">
                                                    </a> 
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div class="slider-pagination d-sm-block d-none"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endif @if($homeall->show_section_6 == '1')
<section class="space overflow-hidden bg-smoke">
    <div class="container">
        <!-- Título Centralizado e com Espaçamento Vertical -->
        <div class="row justify-content-center text-center py-5">
            <div class="col-xl-8 col-lg-8">
                <div class="title-area">
                    <span class="shadow-title style2">{!! $homeall->section_6_conteudo_35 !!}</span>
                    <h2 class="sec-title">{!! $homeall->section_6_conteudo_36 !!}</h2>
                    <p class="sec-text text-title">{!! $homeall->section_6_conteudo_37 !!}</p>
                </div>
            </div>
        </div>

        <!-- Swiper -->
        <div class="swiper th-slider aminities-slider" id="aminitiesSlider1"
            data-slider-options='{
                "pagination": {
                    "el": ".slider-pagination",
                    "type": "progressbar"
                },
                "breakpoints": {
                    "0": {"slidesPerView": 1},
                    "375": {"slidesPerView": 2},
                    "768": {"slidesPerView": 3},
                    "992": {"slidesPerView": 4},
                    "1200": {"slidesPerView": 6}
                }
            }'>

            <div class="swiper-wrapper">
                @if($homeall->carousel_3)
                    @foreach (json_decode($homeall->carousel_3, true) as $key => $value)
                        <div class="swiper-slide"> 
                            <a href="{{ $value['link_1'] }}" class="aminities-card" data-mask-src="{{ uploaded_asset($value['img_1']) }}">
                                <div class="aminities-card-img"> 
                                    <img src="{{ uploaded_asset($value['img_2']) }}" alt="aminities image"> 
                                </div>
                                <div class="aminities-content">
                                    <div class="aminities-card-icon"> 
                                        <img src="{{ uploaded_asset($value['img_3']) }}" alt="aminities icon"> 
                                    </div>
                                    <h3 class="box-title">{{ $value['content_4'] }}</h3>
                                </div>
                            </a> 
                        </div>
                    @endforeach
                @endif
            </div>

            <!-- Paginação apenas no MOBILE -->
            <div class="slider-pagination d-md-none mt-3"></div> 

            <!-- Botões apenas no DESKTOP -->
            <button data-slider-prev="#aminitiesSlider1" class="slider-arrow slider-prev d-none d-md-inline-block">
                <img src="{{ uploaded_asset($homeall->section_6_img_38) }}{{ static_asset('themes/clinica/assets/img/icon/arrow-left.svg') }}" alt="icon">
            </button> 
            <button data-slider-next="#aminitiesSlider1" class="slider-arrow slider-next d-none d-md-inline-block">
                <img src="{{ uploaded_asset($homeall->section_6_img_39) }}{{ static_asset('themes/clinica/assets/img/icon/arrow-right.svg') }}" alt="icon">
            </button>
        </div>
    </div>
</section>

@endif @if($homeall->show_section_7 == '1')
<div class="container bg-smoke">
    <div class="video-area-1">
        <div class="video-wrap1">
            <div class="video-box1"> <img class="lazy" src="{{ uploaded_asset($homeall->section_7_img_38) }}" alt="{!! $homeall->section_7_image_alt_38 !!}" loading="lazy"> <a href="{{ $homeall->section_7_link_39 }}" class="play-btn style3 popup-video" aria-label="{!! $homeall->section_7_link_alt_39 !!}"><i class="fa-sharp fa-solid fa-play"></i></a> </div>
            <div class="video-wrap-details">
                <div class="title-area mb-45">
                    <h2 class="sec-title">{!! $homeall->section_7_conteudo_40 !!}</h2>
                    <p class="sec-text text-title">{!! $homeall->section_7_conteudo_41 !!}</p>
                </div>
                <div class="btn-wrap mb-55"> <a href="{{ $homeall->section_7_link_42 }}" class="th-btn style2 btn-mask th-btn-icon" aria-label="{!! $homeall->section_7_link_alt_42 !!}">{!! $homeall->section_7_link_conteudo_42 !!}</a> </div>
                <div class="author-grid">
                    <div class="author-profile">
                        <div class="avater"> <img class="lazy" src="{{ uploaded_asset($homeall->section_7_img_43) }}" alt="{!! $homeall->section_7_image_alt_43 !!}" loading="lazy"> </div>
                        <div class="media-body">
                            <h5 class="author-profile-name">{!! $homeall->section_7_conteudo_44 !!}</h5>
                            <p class="author-desig">{!! $homeall->section_7_conteudo_45 !!}</p>
                        </div>
                    </div>
                    <div class="author-sign"> <img class="lazy" src="{{ uploaded_asset($homeall->section_7_img_46) }}" alt="{!! $homeall->section_7_image_alt_46 !!}" loading="lazy"> </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif @if($homeall->show_section_8 == '1')
<section class="team-area-1 space-bottom bg-theme sec" id="team-sec">
    <div class="container z-index-common">
        <div class="row justify-content-between align-items-center">
            <div class="col-xl-5 col-lg-7">
                <div class="title-area"> <span class="shadow-title">{!! $homeall->section_8_conteudo_47 !!}</span>
                    <h2 class="sec-title text-white">{!! $homeall->section_8_conteudo_48 !!}</h2>
                    <p class="sec-text text-white">{!! $homeall->section_8_conteudo_49 !!}</p>
                </div>
            </div>
            <div class="col-auto">
                <div class="sec-btn"> <a href="{{ $homeall->section_8_link_50 }}" class="th-btn btn-mask th-btn-icon" aria-label="{!! $homeall->section_8_link_alt_50 !!}">{!! $homeall->section_8_link_conteudo_50 !!}</a> </div>
            </div>
        </div>
        <div class="swiper th-slider team-slider1" id="teamSlider1" data-slider-options='{"paginationType":"progressbar","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}'>
            <div class="swiper-wrapper">
                @if($teams)
                    @foreach($teams as $team)
                        @if(isset($team->value) && $team->value != null && $team->value != 'null')
                            @foreach(json_decode($team->value, true) as $key => $value)
                                <div class="swiper-slide">
                                    <div class="th-team team-card">
                                        <div class="img-wrap">
                                            <div class="team-img" data-mask-src="{{ static_asset('themes/clinica/assets/img/theme-img/team-shape1.png') }}"> 
                                                <img src="{{ uploaded_asset($value['imagem']) }}" alt="{!! $value['legenda'] !!}" class="lazy" loading="lazy" />
                                            </div>
                                        </div>
                                        <div class="team-card-content">
                                            <div class="media">
                                                <div class="media-left">
                                                    <h3 class="box-title">
                                                        <a href="">{!! $value['name'] !!}</a>
                                                    </h3> 
                                                    <span class="team-desig">{!! $value['position'] !!}</span>
                                                </div>
                                            </div>
                                            <div class="th-social"> 
                                                    @if (!empty($value['linkOne']))
                                                        <a target="_blank" href="{{ $value['linkOne'] }}" aria-label="{{ $value['captionlinkOne'] ?? 'Twitter link' }}">
                                                            <i class="fab fa-twitter"></i>
                                                        </a> 
                                                    @endif
                                                                                    
                                                    @if (!empty($value['linkTwo']))
                                                        <a target="_blank" href="{{ $value['linkTwo'] }}" aria-label="{{ $value['captionlinkTwo'] ?? 'LinkedIn link' }}">
                                                            <i class="fab fa-linkedin-in"></i>
                                                        </a>
                                                    @endif
                                                    @if (!empty($value['linkThree']))
                                                        <a target="_blank" href="{{ $value['linkThree'] }}" aria-label="{{ $value['captionlinkThree'] ?? 'LinkedIn link' }}">
                                                            <i class="fab fa-linkedin-in"></i>
                                                        </a>
                                                    @endif @if (!empty($value['linkFuor']))
                                                        <a target="_blank" href="{{ $value['linkFour'] }}" aria-label="{{ $value['captionlinkFuor'] ?? 'LinkedIn link' }}">
                                                            <i class="fab fa-linkedin-in"></i>
                                                        </a>
                                                    @endif
                                                    @if (!empty($value['linkFive']))
                                                        <a target="_blank" href="{{ $value['linkFive'] }}" aria-label="{{ $value['captionlinkFive'] ?? 'Instagram link' }}">
                                                            <i class="fab fa-instagram"></i>
                                                        </a> 
                                                    @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    @endforeach
                @endif
            </div>
            <div class="slider-pagination"></div> <button data-slider-prev="#teamSlider1" class="slider-arrow slider-prev">
                <img class="lazy" src="{{ uploaded_asset($homeall->section_8_img_51) }}" alt="{!! $homeall->section_8_image_alt_51 !!}" loading="lazy">
            </button> 
            <button data-slider-next="#teamSlider1" class="slider-arrow slider-next">
                <img class="lazy" src="{{ uploaded_asset($homeall->section_8_img_52) }}" alt="{!! $homeall->section_8_image_alt_52 !!}" loading="lazy">
            </button>
        </div>
    </div>
</section>
@endif @if($homeall->show_section_9 == '1')
<section class="space-bottom overflow-hidden " style="background-color:#ec622a" id="contact-sec">
    <div class="container">
        <div class="row gy-80 gx-40 align-items-center">
            <div class="col-xl-6">
                <div class="cta-thumb img-shine" data-mask-src="{{ static_asset('themes/clinica/assets/img/shape/cta_1_1-img-mask.png') }}" style="margin-top: 80px;"> <img class="lazy" src="{{ uploaded_asset($homeall->section_9_img_53) }}" alt="{!! $homeall->section_9_image_alt_53 !!}" loading="lazy"> </div>
            </div>
            <div class="col-xl-6">
                <div class="me-xxl-5 pe-xxl-5">
                    <div class="title-area"> <span class="shadow-title">{!! $homeall->section_9_conteudo_54 !!}</span>
                        <h2 class="sec-title text-white">{!! $homeall->section_9_conteudo_55 !!}</h2>
                        <p class="sec-text text-white">{!! $homeall->section_9_conteudo_56 !!}</p>
                    </div>
                    <div class="btn-wrap"> 
                        <a href="{{ $homeall->section_9_link_57 }}" class="th-btn btn-mask2 th-btn-icon" aria-label="{!! $homeall->section_9_link_alt_57 !!}">{!! $homeall->section_9_link_conteudo_57 !!}</a> 
                        <a href="{{ $homeall->section_9_link_58 }}" class="th-btn btn-mask2 th-btn-icon" aria-label="{!! $homeall->section_9_link_alt_58 !!}">{!! $homeall->section_9_link_conteudo_58 !!}</a> 
                        </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endif @if($homeall->show_section_10 == '1')
<section class="testi-sec-1 overflow-hidden space overflow-hidden bg-smoke">
    <div class="container">
        <div class="row gy-80 flex-row-reverse">
            <div class="col-xl-5">
                <div class="testi-thumb-wrap">
                    <div class="img1"> <img class="lazy" src="{{ uploaded_asset($homeall->section_10_img_59) }}" alt="{!! $homeall->section_10_image_alt_59 !!}" loading="lazy"> </div>
                    <div class="img2 jump"> <img class="lazy" src="{{ uploaded_asset($homeall->section_10_img_60) }}" alt="{!! $homeall->section_10_image_alt_60 !!}" width="330" height="311" loading="lazy"> </div>
                </div>
            </div>
            <div class="col-xl-7">
                <div class="title-area"> <span class="shadow-title style2">{!! $homeall->section_10_conteudo_61 !!}</span>
                    <h2 class="sec-title">{!! $homeall->section_10_conteudo_62 !!}</h2>
                </div>
                <div class="swiper th-slider testi-slider1" id="testiSlider1" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}'>
                    <div class="swiper-wrapper">
                        @if($comentarios)
                            @foreach($comentarios as $comentario)
                                @if(isset($comentario->value) && $comentario->value != null && $comentario->value != 'null')
                                    @foreach(json_decode($comentario->value, true) as $key => $value)
                                        <div class="swiper-slide">
                                            <div class="testi-card">
                                                <div class="testi-grid_review"> 
                                                    <i class="fa-sharp fa-solid fa-star"></i>
                                                    <i class="fa-sharp fa-solid fa-star"></i>
                                                    <i class="fa-sharp fa-solid fa-star"></i>
                                                    <i class="fa-sharp fa-solid fa-star"></i>
                                                    <i class="fa-sharp fa-solid fa-star"></i> 
                                                </div>
                                                <p class="testi-card_text">{!! $value['contentOne'] !!}</p>
                                                <div class="testi-grid-wrap">
                                                    <div class="testi-card_profile">
                                                        <div class="avatar" data-mask-src="{{ static_asset('themes/clinica/assets/img/shape/testi_1_1-mask.png') }}"> 
                                                            <img src="{{ uploaded_asset($value['foto']) }}" alt="{!! $value['captionTwo'] !!}"> 
                                                        </div>
                                                        <div class="testi-card_profile-details">
                                                            <h3 class="testi-card_name">{!! $value['contentTwo'] !!}</h3> 
                                                            <span class="testi-card_desig">{!! $value['contentThree'] !!}</span>
                                                        </div>
                                                    </div>
                                                    <div class="quote-icon"> <img src="{{ static_asset('themes/clinica/assets/img/icon/qoute.svg') }}" alt="icon"> </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            @endforeach
                        @endif
                    </div>
                    <div class="slider-pagination style2"></div>
                </div>
            </div>
        </div>
    </div>
</section>
@endif @if($homeall->show_section_11 == '1')
<section class="download-area-1 space-top overflow-hidden sec" data-bg-src="{{ uploaded_asset($homeall->section_11_img_68) }}" data-opacity="5" data-overlay="title">
    <div class="container">
        <div class="row gx-40">
            <div class="col-xxl-6 col-lg-7 align-self-center">
                <div class="space-bottom text-lg-start text-center">
                    <div class="title-area mb-30"> <span class="shadow-title">{!! $homeall->section_11_conteudo_63 !!}</span>
                        <h2 class="sec-title text-white">{!! $homeall->section_11_conteudo_64 !!}</h2>
                        <p class="sec-text text-white">{!! $homeall->section_11_conteudo_65 !!}</p>
                    </div>
                    <div class="btn-wrap justify-content-lg-start justify-content-center"> <a href="{{ $homeall->section_11_link_66 }}" class="th-btn btn-mask th-btn-icon" aria-label="{!! $homeall->section_11_link_alt_66 !!}">{!! $homeall->section_11_link_conteudo_66 !!}</a> </div>
                </div>
            </div>
            <div class="col-xxl-6 col-lg-5 align-self-end">
                <div class="download-thumb text-center"> <img class="lazy" src="{{ uploaded_asset($homeall->section_11_img_67) }}" alt="{!! $homeall->section_11_image_alt_67 !!}" loading="lazy"> </div>
            </div>
        </div>
    </div>
</section>
@endif
@if ($homeall->show_section_12 == '1')
    <section class="space bg-theme" id="blog-sec">
        <div class="container" style="margin-top:80px">
            <div class="row justify-content-between align-items-center">
                <div class="col-xl-5 col-lg-7">
                    <div class="title-area"> <span class="shadow-title">{!! $homeall->section_12_conteudo_341 !!}</span>
                        <h2 class="sec-title text-white">{!! $homeall->section_12_conteudo_342 !!}</h2>
                    </div>
                </div>
                <div class="col-lg-auto">
                    <div class="sec-btn">
                        <a href="{{ $homeall->section_12_link_343 }}" class="th-btn style-border3 th-btn-icon" aria-label="{!! $homeall->section_12_link_alt_343 !!}">
                            {!! $homeall->section_12_link_conteudo_343 !!}
                        </a>
                    </div>
                </div>
            </div>
            @if($blogs)
                @foreach($blogs as $blog)
                    <div class="blog-grid">
                        <div class="blog-img img-shine" data-mask-src="{{ static_asset('themes/clinica/assets/img/shape/blog-card1-img-mask.png') }}"> 
                            <a href="{!! url('blog') . '/' . $blog->slug !!}"> 
                                <img src="{{ uploaded_asset($blog->banner) }}" alt="blog image"> 
                            </a> 
                        </div>
                        <div class="blog-content">
                            <h3 class="box-title"><a href="{{ url("blog").'/'. $blog->slug }}">{{ $blog->title }}</a></h3>
                            <p class="blog-text">{{ $blog->short_description }}</p>
                            <div class="blog-bottom-wrap">
                                <div class="blog-author-wrap">
                                    <div class="avatar"> 
                                        <img src="{{ uploaded_asset($blog->meta_img) }}"  alt="" style="width:80%"> 
                                    </div>
                                </div>
                                <div class="blog-date"> {{ date('d M Y',strtotime($blog->created_at)) }} </div> <a href="{{ url("blog").'/'. $blog->slug }}" class="th-btn btn-mask th-btn-icon">Leia mais</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </section>
@endif
@endsection
