@extends('backend.layouts.app')

@section('content')

    <div class="aiz-titlebar text-left mt-2 mb-3">
    	<div class="row align-items-center">
    		<div class="col">
    			<h1 class="h3">{{ translate('Rodapé do site') }}</h1>
    		</div>
    	</div>
    </div>
    <div class="card">
    	<div class="card-header">
    		<h6 class="fw-600 mb-0">{{ translate('Widget de rodapé') }}</h6>
    	</div>
    	<div class="card-body">
    		<div class="row gutters-10">
				<!-- About Widget -->
    			<div class="col-lg-6">
    				<div class="card shadow-none bg-light">
    					<div class="card-header">
    						<h6 class="mb-0">{{ translate('Sobre o widget') }}</h6>
    					</div>
    					<div class="card-body">
    						<form action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
    							@csrf
								<!-- Footer Logo -->
    							<div class="form-group">
    			                    <label class="form-label" for="signinSrEmail">{{ translate('Logotipo do rodapé') }}</label>
    			                    <div class="input-group " data-toggle="aizuploader" data-type="image">
    			                        <div class="input-group-prepend">
    			                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar') }}</div>
    			                        </div>
    			                        <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
    									<input type="hidden" name="types[]" value="footer_logo">
    			                        <input type="hidden" name="footer_logo" class="selected-files" value="{{ get_setting('footer_logo') }}">
    			                    </div>
    								<div class="file-preview"></div>
                                    <small class="text-muted">{{ translate("Minimum dimensions required: 275px width X 44px height.") }}</small>
    			                </div>
								<!-- About description -->
    			                <div class="form-group">
    								<label>{{ translate('Sobre a descrição') }} ({{ translate('Traduzível') }})</label>
    								<input type="hidden" name="types[][{{ $lang }}]" value="about_us_description">
    								<textarea class="aiz-text-editor form-control" name="about_us_description" placeholder="Type.." data-min-height="150">
                                        {!! get_setting('about_us_description',null,$lang); !!}
                                    </textarea>
    							</div>
								<!-- Update Button -->
								<div class="mt-4 text-right">
									<button type="submit" class="btn btn-success w-230px btn-md rounded-2 fs-14 fw-700 shadow-success">{{ translate('Atualizar') }}</button>
								</div>
    						</form>
    					</div>
    				</div>
    			</div>

				<!-- Contact Info Widget -->
    			<div class="col-lg-6">
                    <div class="card shadow-none bg-light">
    					<div class="card-header">
    						<h6 class="mb-0">{{ translate('Widget de informações de contato') }}</h6>
    					</div>
    					<div class="card-body">
                            <form action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
    							@csrf
								<!-- Contact address -->
								<div class="form-group">
    								<label>Hórario de funcionamento</label>
    								<input type="hidden" name="types[]" value="horario">
    								<input type="text" class="form-control" placeholder="Hórario" name="horario" value="{{ get_setting('horario') }}">
    							</div>
                                <div class="form-group">
    								<label>{{ translate('Endereço de contato') }} ({{ translate('Traduzível') }})</label>
    								<input type="hidden" name="types[][{{ $lang }}]" value="contact_address">
    								<input type="text" class="form-control" placeholder="{{ translate('Endereço') }}" name="contact_address" value="{{ get_setting('contact_address',null,$lang) }}">
    							</div>
    							 
								<!-- Contact phone -->
                                <div class="form-group">
    								<label>{{ translate('Telefone de contato') }}</label>
    								<input type="hidden" name="types[]" value="contact_phone">
    								<input type="text" class="form-control" placeholder="{{ translate('Telefone') }}" name="contact_phone" value="{{ get_setting('contact_phone') }}">
    							</div>
    							<div class="form-group">
    								<label>Telefone de flutuante</label>
    								<input type="hidden" name="types[]" value="contact_flutuante">
    								<input type="text" class="form-control" placeholder="Telefone Flutuante" name="contact_flutuante" value="{{ get_setting('contact_flutuante') }}">
    							</div>
    							<div class="form-group">
    								<label>Whatsapp de flutuante</label>
    								<input type="hidden" name="types[]" value="wpp_flutuante">
    								<input type="text" class="form-control" placeholder="Whatsapp Flutuante" name="wpp_flutuante" value="{{ get_setting('wpp_flutuante') }}">
    							</div>
								<!-- Contact email -->
                                <div class="form-group">
    								<label>{{ translate('E-mail de contato') }}</label>
    								<input type="hidden" name="types[]" value="contact_email">
    								<input type="text" class="form-control" placeholder="{{ translate('E-mail') }}" name="contact_email" value="{{ get_setting('contact_email') }}">
    							</div>
								<!-- Update Button -->
								<div class="mt-4 text-right">
									<button type="submit" class="btn btn-success w-230px btn-md rounded-2 fs-14 fw-700 shadow-success">{{ translate('Atualizar') }}</button>
								</div>
    						</form>
    					</div>
    				</div>
    			</div>


    		</div>
    	</div>
    </div>

	<!-- Footer Bottom -->
    <div class="card">
    	<div class="card-header">
    		<h6 class="fw-600 mb-0">{{ translate('Parte inferior do rodapé') }}</h6>
    	</div>
        <form action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
           <div class="card-body">
				<!-- Social Link Widget -->
                <div class="card shadow-none bg-light">
                  <div class="card-header">
						<h6 class="mb-0">{{ translate('Widget de links sociais') }}</h6>
					</div>
                  <div class="card-body">
                    <div class="form-group row">
                      <label class="col-md-2 col-from-label">{{translate('Mostrar links sociais?')}}</label>
                      <div class="col-md-9">
                        <label class="aiz-switch aiz-switch-success mb-0">
                          <input type="hidden" name="types[]" value="show_social_links">
                          <input type="checkbox" name="show_social_links" @if( get_setting('show_social_links') == 'on') checked @endif>
                          <span></span>
                        </label>
                      </div>
                    </div>
                    <div class="form-group">
                        <label>{{ translate('Links Sociais') }}</label>
						<!-- Facebook Link -->
                        <div class="input-group form-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="lab la-facebook-f"></i></span>
                            </div>
                            <input type="hidden" name="types[]" value="facebook_link">
                            <input type="text" class="form-control" placeholder="http://" name="facebook_link" value="{{ get_setting('facebook_link')}}">
                        </div>
						<!-- Twitter Link -->
                        <div class="input-group form-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="lab la-twitter"></i></span>
                            </div>
                            <input type="hidden" name="types[]" value="twitter_link">
                            <input type="text" class="form-control" placeholder="http://" name="twitter_link" value="{{ get_setting('twitter_link')}}">
                        </div>
						<!-- Instagram Link -->
                        <div class="input-group form-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="lab la-instagram"></i></span>
                            </div>
                            <input type="hidden" name="types[]" value="instagram_link">
                            <input type="text" class="form-control" placeholder="http://" name="instagram_link" value="{{ get_setting('instagram_link')}}">
                        </div>
						<!-- Youtube Link -->
                        <div class="input-group form-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="lab la-youtube"></i></span>
                            </div>
                            <input type="hidden" name="types[]" value="youtube_link">
                            <input type="text" class="form-control" placeholder="http://" name="youtube_link" value="{{ get_setting('youtube_link')}}">
                        </div>
						<!-- Linkedin Link -->
                        <div class="input-group form-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="lab la-linkedin-in"></i></span>
                            </div>
                            <input type="hidden" name="types[]" value="linkedin_link">
                            <input type="text" class="form-control" placeholder="http://" name="linkedin_link" value="{{ get_setting('linkedin_link')}}">
                        </div>
                    </div>
                  </div>
                </div>

				<!-- Update Button -->
				<div class="mt-4 text-right">
					<button type="submit" class="btn btn-success w-230px btn-md rounded-2 fs-14 fw-700 shadow-success">{{ translate('Atualizar') }}</button>
				</div>
            </div>
        </form>
	</div>
@endsection
