<form action="{{ route('contact.reply') }}" method="POST">
    @csrf
    <input type="hidden" name="contact_id" value="{{ $contact->id }}">
    <div class="modal-header">
        <h5 class="modal-title h6">{{translate('Responder à consulta')}}</h5>
        <button type="button" class="close" data-dismiss="modal">
        </button>
    </div>
    <div class="modal-body">
        <!-- Name -->
        <div class="form-group">
            <label for="name" class="fs-12 fw-700 text-soft-dark">{{  translate('Nome') }}</label>
            <input type="text" class="form-control rounded-0" value="{{$contact->name }}" placeholder="{{  translate('Digite o nome') }}" name="name" required readonly>
        </div>
        <!-- Email -->
        <div class="form-group">
            <label for="email" class="fs-12 fw-700 text-soft-dark">{{  translate('E-mail') }}</label>
            <input type="email" class="form-control rounded-0" value="{{ $contact->email }}" placeholder="{{  translate('Digite o e-mail') }}" name="email" required readonly>
        </div>
        <!-- Reply -->
        <div class="form-group">
            <label for="reply" class="fs-12 fw-700 text-soft-dark">{{  translate('Responder à consulta') }}</label>
            <textarea
                class="form-control rounded-0"
                placeholder="{{translate('Digite aqui...')}}"
                name="reply"
                rows="3"
                required
            ></textarea>
        </div>
    </div>
    <div class="modal-footer">
        <button type="submit" class="btn btn-primary">{{translate('Enviar')}}</button>
        <button type="button" class="btn btn-light" data-dismiss="modal">{{translate('Cancelar')}}</button>
    </div>
</form>
