@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Credencial de login do Google') }}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('env_key_update.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="GOOGLE_CLIENT_ID">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('ID do cliente') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="GOOGLE_CLIENT_ID"
                                    value="{{ env('GOOGLE_CLIENT_ID') }}" placeholder="{{ translate('ID do cliente Google') }}"
                                    required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="GOOGLE_CLIENT_SECRET">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('Segredo do cliente') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="GOOGLE_CLIENT_SECRET"
                                    value="{{ env('GOOGLE_CLIENT_SECRET') }}"
                                    placeholder="{{ translate('Segredo do cliente Google') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{ translate('Salvar') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Credencial de login do Facebook') }}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('env_key_update.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="FACEBOOK_CLIENT_ID">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('ID do aplicativo') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="FACEBOOK_CLIENT_ID"
                                    value="{{ env('FACEBOOK_CLIENT_ID') }}"
                                    placeholder="{{ translate('ID do cliente do Facebook') }}" required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="FACEBOOK_CLIENT_SECRET">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('Segredo do aplicativo') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="FACEBOOK_CLIENT_SECRET"
                                    value="{{ env('FACEBOOK_CLIENT_SECRET') }}"
                                    placeholder="{{ translate('Segredo do cliente do Facebook') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{ translate('Salvar') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Credencial de login do Twitter') }}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('env_key_update.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="TWITTER_CLIENT_ID">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('ID do cliente') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="TWITTER_CLIENT_ID"
                                    value="{{ env('TWITTER_CLIENT_ID') }}"
                                    placeholder="{{ translate('ID do cliente do Twitter') }}" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="TWITTER_CLIENT_SECRET">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('Segredo do cliente') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="TWITTER_CLIENT_SECRET"
                                    value="{{ env('TWITTER_CLIENT_SECRET') }}"
                                    placeholder="{{ translate('Segredo do cliente do Twitter') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{ translate('Salvar') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Credencial de login da Apple') }}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('env_key_update.update') }}" method="POST">
                        @csrf
                        <input type="hidden" name="types[]" value="SIGN_IN_WITH_APPLE_LOGIN">
                        <input type="hidden" name="SIGN_IN_WITH_APPLE_LOGIN" value="{{ url('/users/login') }}"
                            required>
                        <input type="hidden" name="types[]" value="SIGN_IN_WITH_APPLE_REDIRECT">
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="SIGN_IN_WITH_APPLE_REDIRECT">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('URL de retorno de chamada') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="SIGN_IN_WITH_APPLE_REDIRECT" value="{{ url('/apple-callback') }}" readonly>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="SIGN_IN_WITH_APPLE_CLIENT_ID">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('ID do cliente') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="SIGN_IN_WITH_APPLE_CLIENT_ID"
                                    value="{{ env('SIGN_IN_WITH_APPLE_CLIENT_ID') }}"
                                    placeholder="{{ translate('ID do cliente Apple') }}" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="SIGN_IN_WITH_APPLE_CLIENT_SECRET">
                            <div class="col-lg-3">
                                <label class="col-from-label">{{ translate('Segredo do cliente') }}</label>
                            </div>
                            <div class="col-md-7">
                                <input type="text" class="form-control" name="SIGN_IN_WITH_APPLE_CLIENT_SECRET"
                                    value="{{ env('SIGN_IN_WITH_APPLE_CLIENT_SECRET') }}"
                                    placeholder="{{ translate('Segredo do cliente Apple') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{ translate('Salvar') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
