@extends('backend.layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Selecione o método de envio')}}</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('shipping_configuration.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="type" value="shipping_type">
                    <div class="radio mar-btm">
                        <input id="product-shipping" class="magic-radio" type="radio" name="shipping_type" value="product_wise_shipping" @if(get_setting('shipping_type') == 'product_wise_shipping') checked @endif>
                        <label for="product-shipping">
                            <span>{{translate('Custo de envio do produto')}}</span>
                            <span></span>
                        </label>
                    </div>
                    <div class="radio mar-btm">
                        <input id="flat-shipping" class="magic-radio" type="radio" name="shipping_type" value="flat_rate" @if(get_setting('shipping_type') == 'flat_rate') checked @endif>
                        <label for="flat-shipping">{{translate('Custo de envio de taxa fixa')}}</label>
                    </div>
                    <div class="radio mar-btm">
                        <input id="seller-shipping" class="magic-radio" type="radio" name="shipping_type" value="seller_wise_shipping" @if(get_setting('shipping_type') == 'seller_wise_shipping') checked @endif>
                        <label for="seller-shipping">{{translate('Custo de envio fixo do vendedor')}}</label>
                    </div>
                    <div class="radio mar-btm">
                        <input id="area-shipping" class="magic-radio" type="radio" name="shipping_type" value="area_wise_shipping" @if(get_setting('shipping_type') == 'area_wise_shipping') checked @endif>
                        <label for="area-shipping">{{translate('Custo de envio fixo por área')}}</label>
                    </div>
                    <div class="radio mar-btm">
                        <input id="weight-shipping" class="magic-radio" type="radio" name="shipping_type" value="carrier_wise_shipping" @if(get_setting('shipping_type') == 'carrier_wise_shipping') checked @endif>
                        <label for="weight-shipping">
                            {{translate('Custo de envio sábio da transportadora')}}
                        </label>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Observação')}}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group">
                    <li class="list-group-item">
                        1. {{ translate('Cálculo do custo de envio do produto: o custo de envio é calculado pela adição do custo de envio de cada produto') }}.
                    </li>
                    <li class="list-group-item">
                        2. {{ translate('Cálculo do custo de envio com taxa fixa: não importa quantos produtos um cliente compra. O custo de envio é fixo') }}.
                    </li>
                    <li class="list-group-item">
                        3. {{ translate('Cálculo do custo de envio fixo do vendedor: taxa fixa para cada vendedor. Se os clientes comprarem 2 produtos de dois vendedores, o custo de envio será calculado pela adição do custo fixo de envio de cada vendedor') }}.
                    </li>
                    <li class="list-group-item">
                        4. {{ translate('Cálculo do custo de envio fixo por área: taxa fixa para cada área. Se os clientes comprarem vários produtos de um vendedor, o custo de envio será calculado pela área de envio do cliente. Para configurar o custo de envio por área, vá para') }} <a href="{{ route('cities.index') }}">{{ translate('Cidades de embarque') }}</a>.
                    </li>
                    <li class="list-group-item">
                        5. {{ translate('Cálculo do custo de envio com base na transportadora: O custo de envio é calculado adicionalmente com a transportadora. Em cada transportadora você pode definir o custo de frete grátis ou definir a faixa de peso ou o custo de frete. Para configurar o custo de envio baseado na transportadora, acesse') }} <a href="{{ route('carriers.index') }}">{{ translate('Transportadoras') }}</a>.
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Custo de taxa fixa')}}</h5>
            </div>
            <form action="{{ route('shipping_configuration.update') }}" method="POST" enctype="multipart/form-data">
              <div class="card-body">
                  @csrf
                  <input type="hidden" name="type" value="flat_rate_shipping_cost">
                  <div class="form-group">
                      <div class="col-lg-12">
                          <input class="form-control" type="text" name="flat_rate_shipping_cost" value="{{ get_setting('flat_rate_shipping_cost') }}">
                      </div>
                  </div>
                  <div class="form-group mb-0 text-right">
                      <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                  </div>
              </div>
            </form>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Observação')}}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group">
                    <li class="list-group-item">
                        {{ translate('1. O custo de envio com taxa fixa será aplicável se o envio com taxa fixa estiver ativado.') }}
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Custo de envio para produtos administrativos')}}</h5>
            </div>
            <form action="{{ route('shipping_configuration.update') }}" method="POST" enctype="multipart/form-data">
              <div class="card-body">
                  @csrf
                  <input type="hidden" name="type" value="shipping_cost_admin">
                  <div class="form-group">
                      <div class="col-lg-12">
                          <input class="form-control" type="text" name="shipping_cost_admin" value="{{ get_setting('shipping_cost_admin') }}">
                      </div>
                  </div>
                  <div class="form-group mb-0 text-right">
                      <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                  </div>
              </div>
            </form>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{translate('Observação')}}</h5>
            </div>
            <div class="card-body">
                <ul class="list-group">
                    <li class="list-group-item">
                        {{ translate('1. O custo de envio para administrador é aplicável se o custo de envio do vendedor estiver ativado.') }}
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

@endsection
