@extends('backend.layouts.app')

@section('content')

    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0 h6 text-center">{{translate('Ativação da Comissão do Vendedor')}}</h3>
                </div>
                <div class="card-body text-center">
                    <label class="aiz-switch aiz-switch-success mb-0">
                        <input type="checkbox" onchange="updateSettings(this, 'vendor_commission_activation')" <?php if(get_setting('vendor_commission_activation') == 1) echo "checked";?>>
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{translate('Observação')}}</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item text-muted">
                            1. {{ translate('Se o tipo de comissão for taxa fixa') }}, {{ get_setting('vendor_commission') }}% {{translate('do preço do produto do vendedor será deduzido dos ganhos do vendedor') }}.
                        </li>
                        <li class="list-group-item text-muted">
                            2. {{ translate('Se o tipo de comissão for baseado no vendedor, defina a porcentagem de comissão') }} <a href="{{ route('sellers.index') }}">{{ translate('Aqui') }}</a>
                        </li>
                        <li class="list-group-item text-muted">
                            3. {{ translate('Se o tipo de comissão for baseado em categoria, defina a porcentagem de comissão') }} <a href="{{ route('categories.index') }}">{{ translate('Aqui') }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0 h6 text-center">{{translate('Tipo de comissão')}}</h3>
                </div>
                <form class="form-horizontal" action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="types[]" value="seller_commission_type">
                    <div class="card-body">
                        <div class="radio mar-btm">
                            <input id="fixed_commission_rate" class="magic-radio" type="radio" name="seller_commission_type" value="fixed_rate" @if(get_setting('seller_commission_type') == 'fixed_rate') checked @endif>
                            <label for="fixed_commission_rate" class="fs-13">{{translate('Taxa de comissão fixa')}}</label>
                        </div>
                        <div class="radio mar-btm">
                            <input id="seller_based_commission" class="magic-radio" type="radio" name="seller_commission_type" value="seller_based" @if(get_setting('seller_commission_type') == 'seller_based') checked @endif>
                            <label for="seller_based_commission" class="fs-13">{{translate('Taxa de comissão baseada no vendedor')}}</label>
                        </div>
                        <div class="radio mar-btm">
                            <input id="category_based_commission" class="magic-radio" type="radio" name="seller_commission_type" value="category_based" @if(get_setting('seller_commission_type') == 'category_based') checked @endif>
                            <label for="category_based_commission" class="fs-13">{{translate('Taxa de comissão baseada em categoria')}}</label>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        @if(get_setting('seller_commission_type') == 'fixed_rate')
            <div class="col-lg-6">
                <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{translate('Taxa de comissão fixa')}}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <label class="col-md-4 col-from-label">{{translate('Comissão do Vendedor')}}</label>
                            <div class="col-md-8">
                                <input type="hidden" name="types[]" value="vendor_commission">
                                <div class="input-group">
                                    <input type="number" lang="en" min="0" step="0.01" value="{{ get_setting('vendor_commission') }}" placeholder="{{translate('Comissão do Vendedor')}}" name="vendor_commission" class="form-control">
                                    <div class="input-group-append">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                        </div>
                    </form>
                </div>
                </div>
            </div>
        @endif

        <div class="col-lg-6">
            <div class="card">
              <div class="card-header">
                  <h5 class="mb-0 h6">{{translate('Retirar valor do vendedor')}}</h5>
              </div>
              <div class="card-body">
                  <form class="form-horizontal" action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
                  	@csrf
                    <div class="form-group row">
                        <label class="col-md-4 col-from-label">{{translate('Retirada do valor mínimo do vendedor')}}</label>
                        <div class="col-md-8">
                            <input type="hidden" name="types[]" value="minimum_seller_amount_withdraw">
                            <div class="input-group">
                                <input type="number" lang="en" min="0" step="0.01" value="{{ get_setting('minimum_seller_amount_withdraw') }}" placeholder="{{translate('Retirada do valor mínimo do vendedor')}}" name="minimum_seller_amount_withdraw" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                    </div>
                  </form>
              </div>
            </div>
        </div>

    </div>

@endsection

@section('script')
    <script type="text/javascript">
        function updateSettings(el, type){

            if('{{env('DEMO_MODE')}}' == 'On'){
                AIZ.plugins.notify('info', '{{ translate('Os dados não podem ser alterados no modo de demonstração.') }}');
                return;
            }

            if($(el).is(':checked')){
                var value = 1;
            }
            else{
                var value = 0;
            }

            $.post('{{ route('business_settings.update.activation') }}', {_token:'{{ csrf_token() }}', type:type, value:value}, function(data){
                if(data == 1){
                    AIZ.plugins.notify('success', '{{ translate('Configurações atualizadas com sucesso') }}');
                }
                else{
                    AIZ.plugins.notify('danger', 'Something went wrong');
                }
            });
        }
    </script>
@endsection
