@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar text-left mt-2 mb-3">
        <h5 class="mb-0 h6">{{ translate('Adicionar nova tabela de tamanhos') }}</h5>
    </div>
    <div class="">
        <!-- Error Meassages -->
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        <form class="form form-horizontal mar-top" action="{{route('size-charts.update', $size_chart->id)}}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PATCH">
            <input type="hidden" name="id" value="{{ $size_chart->id }}">
            @csrf
            <div class="row gutters-5">
                <!-- Size Chart Information -->
                <div class="col-lg-7">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0 h6">{{ translate('Informações da tabela de tamanhos') }}</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">{{translate('Nome do gráfico')}} <span class="text-danger">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name="name" value="{{ $size_chart->name }}" placeholder="{{ translate('Nome do gráfico') }}" required>
                                </div>
                            </div>
                            <!-- Category -->
                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">{{ translate('Categoria') }} <span class="text-danger">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" name="category_id" id="category_id" data-selected="{{ $size_chart->category_id }}" data-live-search="true" required>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->getTranslation('name') }}</option>
                                            @foreach ($category->childrenCategories as $childCategory)
                                                @include('categories.child_category', ['child_category' => $childCategory])
                                            @endforeach
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- Images -->
                            <div class="form-group row">
                                <label class="col-md-3 col-form-label" for="signinSrEmail">{{ translate('Imagens') }}</label>
                                <div class="col-md-8">
                                    <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="true">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar')}}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                                        <input type="hidden" name="photos" value="{{ $size_chart->photos }}" class="selected-files">
                                    </div>
                                    <div class="file-preview box sm">
                                    </div>
                                    <small class="text-muted">{{translate('Essas imagens são visíveis no guia de tamanhos do produto ao lado da descrição do tamanho.')}}</small>
                                </div>
                            </div>
                            <!-- Size Description -->
                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">{{translate('Descrição do tamanho')}}</label>
                                <div class="col-md-8">
                                    <textarea class="form-control" name="description" rows="5">{{ $size_chart->description }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Size Configuration -->
                <div class="col-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0 h6">{{translate('Configuração de tamanho')}}</h5>
                        </div>
                        <div class="card-body">
                            <!-- Fit Type -->
                            <div class="form-group row">
                                <label class="col-md-4 col-from-label">{{ translate('Tipo de ajuste') }}</label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" name="fit_type">
                                        <option value="">{{ translate('Selecione o tipo de ajuste') }}</option>
                                        <option value="slim_fit" @if ($size_chart->fit_type == 'slim_fit') selected @endif>{{ translate('Ajuste fino') }}</option>
                                        <option value="regular_fit" @if ($size_chart->fit_type == 'regular_fit') selected @endif>{{ translate('Ajuste normal') }}</option>
                                        <option value="relaxed" @if ($size_chart->fit_type == 'relaxed') selected @endif>{{ translate('Descontraído') }}</option>
                                    </select>
                                </div>
                            </div>
                            <!-- Stretch Type -->
                            <div class="form-group row">
                                <label class="col-md-4 col-from-label">{{ translate('Tipo de estiramento') }}</label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" name="stretch_type">
                                        <option value="">{{ translate('Selecione o tipo de alongamento') }}</option>
                                        <option value="non" @if ($size_chart->stretch_type == 'non') selected @endif>{{ translate('Não') }}</option>
                                        <option value="slight" @if ($size_chart->stretch_type == 'slight') selected @endif>{{ translate('Pouco') }}</option>
                                        <option value="medium" @if ($size_chart->stretch_type == 'medium') selected @endif>{{ translate('Médio') }}</option>
                                        <option value="hign" @if ($size_chart->stretch_type == 'hign') selected @endif>{{ translate('Alto') }}</option>
                                    </select>
                                </div>
                            </div>
                            <!-- Measurement Points -->
                            <div class="form-group row">
                                <label class="col-md-4 col-from-label">{{ translate('Pontos de medição') }} <span class="text-danger">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" onchange="size_combination()" name="measurement_points[]" id="measurement_points" data-selected-text-format="count" data-live-search="true" multiple data-placeholder="{{ translate('Escolha os pontos de medição') }}" required>
                                        @foreach ($measurementPoints as $measurementPoint)
                                            <option value="{{ $measurementPoint->id }}" @if($size_chart->measurement_points != null && in_array($measurementPoint->id, json_decode($size_chart->measurement_points, true))) selected @endif>{{ $measurementPoint->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- Size Options -->
                            <div class="form-group row">
                                <label class="col-md-4 col-from-label">{{ translate('Opções de tamanho') }} <span class="text-danger">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" onchange="size_combination()" name="size_options[]" id="size_options" data-selected-text-format="count" data-live-search="true" multiple data-placeholder="{{ translate('Escolha opções de tamanho') }}" required>
                                        @foreach ($sizeOptions as $sizeOption)
                                            <option value="{{ $sizeOption->id }}" @if($size_chart->size_options != null && in_array($sizeOption->id, json_decode($size_chart->size_options, true))) selected @endif>{{ $sizeOption->value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- Measurement Type -->
                            <div class="form-group row">
                                <label class="col-md-4 col-from-label">{{ translate('Tipo de medição') }}</label>
                                <div class="col-md-8">
                                    <label class="aiz-checkbox mr-4">
                                        <input type="checkbox" name="measurement_option[]" value="inch" id="measurement_option_inch" 
                                            onchange="size_combination()" @if (in_array("inch", json_decode($size_chart->measurement_option, true))) checked @endif>
                                        <span class="has-transition fs-12 fw-400 text-gray-dark hov-text-primary">{{  translate('Polegadas') }}</span>
                                        <span class="aiz-square-check"></span>
                                    </label>
                                    <label class="aiz-checkbox">
                                        <input type="checkbox" name="measurement_option[]" value="cen" id="measurement_option_cen" 
                                            onchange="size_combination()" @if (in_array("cen", json_decode($size_chart->measurement_option, true))) checked @endif>
                                        <span class="has-transition fs-12 fw-400 text-gray-dark hov-text-primary">{{  translate('Centímetro') }}</span>
                                        <span class="aiz-square-check"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{translate('Combinação de tamanhos')}}</h5>
                </div>
                <div class="card-body">
                    <div id="size-combination_body">
                        @include('backend.product.sizeCharts.size_combination_edit', ['size_chart' => $size_chart])
                    </div>
                </div>
            </div>
                
            <!-- Button -->
            <div class="btn-toolbar float-right mb-3" role="toolbar" aria-label="Toolbar with button groups">
                <div class="btn-group" role="group" aria-label="Second group">
                    <button type="submit" class="btn btn-success w-230px btn-md rounded-2 fs-14 fw-700 shadow-success">{{ translate('Salvar') }}</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function size_combination(){
            $("#size-combination_body").html('');
            let measurement_points = $('#measurement_points').val();
            let size_options = $('#size_options').val();
            let measurement_option_inch = $('#measurement_option_inch').prop('checked') ? 1 : 0;
            let measurement_option_cen = $('#measurement_option_cen').prop('checked') ? 1 : 0;
            if ((measurement_points.length > 0) && (size_options.length > 0)) {
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type:"POST",
                    url: "{{ route('size-charts.get-combination') }}",
                    data: {
                        measurement_points : measurement_points,
                        size_options : size_options,
                        measurement_option_inch : measurement_option_inch,
                        measurement_option_cen : measurement_option_cen,
                    },
                    success: function(data){
                        $('#size-combination_body').html(data);
                    }
                });
            }
        }
    </script>
@endsection
