@extends('backend.layouts.app')

@section('content')

<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class="row align-items-center">
        <div class="col-auto">
            <h1 class="h3">{{translate('All Posts')}}</h1>
        </div>
        @can('add_blog')
            <div class="col text-right">
                <a href="{{ route('blog.create') }}" class="btn btn-circle btn-info">
                    <span>{{translate('Add New Post')}}</span>
                </a>
            </div>
        @endcan
    </div>
</div>
<br>
<div class="row">
    <div class="col-lg-10 mx-auto">
        <form id="add_form" class="form-horizontal"
            action="{{ route('blogall.update') }}" method="POST"
            enctype="multipart/form-data">
            @csrf
            <div class="form-body">
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção Blog</h4>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem
                                    </label>
                                    <div class="input-group"
                                        data-toggle="aizuploader"
                                        data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div
                                                class="input-group-text bg-soft-secondary font-weight-medium">
                                                Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">
                                            Escolha arquivo</div>
                                        <input type="hidden" name="types[]"
                                            value="banner">
                                        <input type="hidden"
                                            name="banner"
                                            class="selected-files"
                                            value="{{ $item->banner ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]"
                                    value="banner_alt">
                                <input class="form-control" type="text"
                                    name="banner_alt"
                                    value="{{ $item->banner_alt ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]"
                                    value="title">
                                <input class="form-control" type="text"
                                    name="title"
                                    value="{{ $item->title ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Sub Título</label>
                                <input type="hidden" name="types[]"
                                    value="subtitle">
                                <input class="form-control" type="text"
                                    name="subtitle"
                                    value="{{ $item->subtitle ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Número</label>
                                <input type="hidden" name="types[]"
                                    value="number">
                                <input class="form-control" type="text"
                                    name="number"
                                    value="{{ $item->number ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem
                                    </label>
                                    <div class="input-group"
                                        data-toggle="aizuploader"
                                        data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div
                                                class="input-group-text bg-soft-secondary font-weight-medium">
                                                Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">
                                            Escolha arquivo</div>
                                        <input type="hidden" name="types[]"
                                            value="image">
                                        <input type="hidden"
                                            name="image"
                                            class="selected-files"
                                            value="{{ $item->image ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]"
                                    value="image_alt">
                                <input class="form-control" type="text"
                                    name="image_alt"
                                    value="{{ $item->image_alt ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="card">
    <form class="" id="sort_blogs" action="" method="GET">
        <div class="card-header row gutters-5">
            <div class="col text-center text-md-left">
                <h5 class="mb-md-0 h6">{{ translate('All blog posts') }}</h5>
            </div>

            <div class="col-md-2">
                <div class="form-group mb-0">
                    <input type="text" class="form-control form-control-sm" id="search" name="search"@isset($sort_search) value="{{ $sort_search }}" @endisset placeholder="{{ translate('Type & Enter') }}">
                </div>
            </div>
        </div>
        </form>
        <div class="card-body">
            <table class="table mb-0 aiz-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{translate('Title')}}</th>
                        <th data-breakpoints="lg">{{translate('Category')}}</th>
                        <th data-breakpoints="lg">{{translate('Short Description')}}</th>
                        <th data-breakpoints="lg">{{translate('Status')}}</th>
                        <th class="text-right">{{translate('Options')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($blogs as $key => $blog)
                    <tr>
                        <td>
                            {{ ($key+1) + ($blogs->currentPage() - 1) * $blogs->perPage() }}
                        </td>
                        <td>
                            {{ $blog->title }}
                        </td>
                        <td>
                            @if($blog->category != null)
                                {{ $blog->category->category_name }}
                            @else
                                --
                            @endif
                        </td>
                        <td>
                            {{ $blog->short_description }}
                        </td>
                        <td>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox"
                                    @can('publish_blog') onchange="change_status(this)" @endcan
                                    value="{{ $blog->id }}"
                                    <?php if($blog->status == 1) echo "checked";?>
                                    @cannot('publish_blog') disabled @endcan
                                >
                                <span></span>
                            </label>
                        </td>
                        <td class="text-right">
                            @can('edit_blog')
                                <a class="btn btn-soft-primary btn-icon btn-circle btn-sm" href="{{ route('blog.edit',$blog->id)}}" title="{{ translate('Edit') }}">
                                    <i class="las la-pen"></i>
                                </a>
                            @endcan
                            @can('delete_blog')
                                <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" data-href="{{route('blog.destroy', $blog->id)}}" title="{{ translate('Delete') }}">
                                    <i class="las la-trash"></i>
                                </a>
                            @endcan
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $blogs->appends(request()->input())->links() }}
            </div>
        </div>
</div>

@endsection

@section('modal')
    @include('modals.delete_modal')
@endsection


@section('script')

    <script type="text/javascript">
        function change_status(el){

            if('{{env('DEMO_MODE')}}' == 'On'){
                AIZ.plugins.notify('info', '{{ translate('Data can not change in demo mode.') }}');
                return;
            }

            var status = 0;
            if(el.checked){
                var status = 1;
            }
            $.post('{{ route('blog.change-status') }}', {_token:'{{ csrf_token() }}', id:el.value, status:status}, function(data){
                if(data == 1){
                    AIZ.plugins.notify('success', '{{ translate('Change blog status successfully') }}');
                }
                else{
                    AIZ.plugins.notify('danger', '{{ translate('Something went wrong') }}');
                }
            });
        }
    </script>

@endsection
