<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Servicoall;
use App\Models\Servicosall;
use Artisan;
use CoreComponentRepository;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\URL;
use Str;

class ServicoallController extends Controller
{

    public function index(Request $request)
    {
        $sort_search = null;
        $query = Servicosall::query();
        if ($request->search != null) {
            $query->where('title', 'like', '%' . $request->search . '%');
            $sort_search = $request->search;
        }
        $items = $query->paginate(15);
        return view('backend.themes.' . get_setting('homepage_select') . '.servicosall.index', compact('items', 'sort_search'));
    }
    public function duplicate(Request $request, $id)
    {
        $originalItem = Servicosall::find($id);
        if (!$originalItem) {
            return redirect()->route('servico.index')->with('error', 'Item não encontrado.');
        }
        $newItem = $originalItem->replicate();
        $newItem->slug = Str::slug(Str::random(10));
        $newItem->save();
        $relatedItems = Servicoall::where('theme', get_setting('homepage_select'))
            ->where('product', $originalItem->id)
            ->get();
        foreach ($relatedItems as $relatedItem) {
            $newRelatedItem = $relatedItem->replicate();
            $newRelatedItem->product = $newItem->id;
            $newRelatedItem->save();
        }
        return redirect()->route('servico.edit', $newItem->id)->with('success', 'Item duplicado com sucesso.');
    }
    public function create()
    {
        $originalItem = Servicosall::first();
        if (!$originalItem) {
            $item = new Servicosall();
            $item->title = Str::random(10);
            $item->slug = Str::slug(Str::random(10));
            $item->save();
            return redirect()->route('servico.edit', $item->id);
        }
        $item = $originalItem->replicate();
        $item->slug = Str::slug(Str::random(10));
        $item->save();
        $relatedItems = Servicoall::where('theme', get_setting('homepage_select'))
            ->where('product', $originalItem->id)
            ->get();
        foreach ($relatedItems as $relatedItem) {
            $newRelatedItem = $relatedItem->replicate();
            $newRelatedItem->product = $item->id;
            $newRelatedItem->save();
        }
    
        return redirect()->route('servico.edit', $item->id);
    }


    public function edit($id)
    {
        $itemnew = Servicosall::find($id);
        $items = Servicoall::where('theme', get_setting('homepage_select'))->where('product',$itemnew->id)->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = (object) [];
        }
        return view('backend.themes.' . get_setting('homepage_select') . '.servicosall.edit', compact('item','itemnew'));
    }

    public function destroy($id)
    {
        Servicosall::find($id)->delete();
        $relatedServicos = Servicoall::where('product', $id)->get();
        if ($relatedServicos->isNotEmpty()) {
            foreach ($relatedServicos as $relatedServico) {
                $relatedServico->delete();
            }
        }
        return redirect()->back();
    }

    public function general_setting()
    {
        $items = Servicoall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            dd('Nenhum item encontrado');
        }

        return view('backend.themes.' . get_setting('homepage_select') . '.servicosall.edit', compact('item'));
    }

    public function all_servico(){
        $services = Servicosall::all();
        return view("frontend.".get_setting('homepage_select').".servico", compact('services'));
    }
    public function change_status(Request $request) {
        $item = Servicosall::find($request->id);
        $item->status = $request->status;
        $item->save();
        return 1;
    }
    public function update(Request $request,$id){
        $item = Servicosall::find($id);
        $item->title = $request->title ?? '';
        $item->subtitle = $request->subtitle ?? '';
        $item->image = $request->image ?? '';
        $item->slug = $request->slug ?? '';
        $item->categoria = $request->categoria ?? '';
        $item->meta_title = $request->meta_title ?? '';
        $item->meta_description = $request->meta_description ?? '';
        $item->meta_keywords = $request->meta_keywords ?? '';
        $item->save();
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
                $business_settings = Servicoall::where('type', $type)->where('product', $id)->first();
            } else {
                $business_settings = Servicoall::where('type', $type)->where('product', $id)->first();
            }

            if ($business_settings != null) {
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->product = $id;
                $business_settings->save();
            } else {
                $business_settings = new Servicoall;
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->type = $type;
                $business_settings->product = $id;
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->save();
            }
        }

        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        if ($request->has('tab')) {
            return Redirect::to(URL::previous() . "#" . $request->tab);
        }
        return redirect()->back();
    }
}


