<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Exameall;
use App\Models\Examesall;
use Artisan;
use Str;

class ExamesallController extends Controller
{
    public function index(Request $request)
    {
        $sort_search = null;
        $query = Examesall::query();
        if ($request->search != null) {
            $query->where('title', 'like', '%' . $request->search . '%');
            $sort_search = $request->search;
        }
        $items = $query->paginate(15);
        return view('backend.themes.exameall.' . get_setting('homepage_select') . '.index', compact('items', 'sort_search'));
    }

    public function duplicate(Request $request, $id)
    {
        $originalItem = Examesall::find($id);
        if (!$originalItem) {
            return redirect()->route('exame.index')->with('error', 'Item não encontrado.');
        }
        $newItem = $originalItem->replicate();
        $newItem->slug = Str::slug(Str::random(10));
        $newItem->save();
        $relatedItems = Exameall::where('theme', get_setting('homepage_select'))
            ->where('product', $originalItem->id)
            ->get();
        foreach ($relatedItems as $relatedItem) {
            $newRelatedItem = $relatedItem->replicate();
            $newRelatedItem->product = $newItem->id;
            $newRelatedItem->save();
        }
        return redirect()->route('exame.edit', $newItem->id)->with('success', 'Item duplicado com sucesso.');
    }

    public function create()
    {
        $originalItem = Examesall::first();
        if (!$originalItem) {
            $item = new Examesall();
            $item->title = Str::random(10);
            $item->slug = Str::slug(Str::random(10));
            $item->save();
            return redirect()->route('exame.edit', $item->id);
        }
        $item = $originalItem->replicate();
        $item->slug = Str::slug(Str::random(10));
        $item->save();
        $relatedItems = Exameall::where('theme', get_setting('homepage_select'))
            ->where('product', $originalItem->id)
            ->get();
        foreach ($relatedItems as $relatedItem) {
            $newRelatedItem = $relatedItem->replicate();
            $newRelatedItem->product = $item->id;
            $newRelatedItem->save();
        }

        return redirect()->route('exame.edit', $item->id);
    }


    public function edit($id)
    {
        $itemnew = Examesall::find($id);
        $items = Exameall::where('theme', get_setting('homepage_select'))->where('product', $itemnew->id)->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function ($item) {
                return [$item->type => $item->value];
            })->reduce(function ($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = (object) [];
        }
        return view('backend.themes.exameall.' . get_setting('homepage_select') . '.edit', compact('item', 'itemnew'));
    }

    public function destroy($id)
    {
        Examesall::find($id)->delete();
        $relatedExames = Exameall::where('product', $id)->get();
        if ($relatedExames->isNotEmpty()) {
            foreach ($relatedExames as $relatedExame) {
                $relatedExame->delete();
            }
        }
        return redirect()->back();
    }

    public function general_setting()
    {
        $items = Exameall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function ($item) {
                return [$item->type => $item->value];
            })->reduce(function ($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            dd('Nenhum item encontrado');
        }

        return view('backend.themes.exameall.' . get_setting('homepage_select') . '.edit', compact('item'));
    }

    public function all_exame()
    {
        $services = Examesall::all();
        return view("frontend." . get_setting('homepage_select') . ".exame", compact('services'));
    }
    public function change_status(Request $request)
    {
        $item = Examesall::find($request->id);
        $item->status = $request->status;
        $item->save();
        return 1;
    }

    public function update(Request $request, $id)
    {
        $item = Examesall::find($id);
        $item->title = $request->title ?? '';
        $item->subtitle = $request->subtitle ?? '';
        $item->image = $request->image ?? '';
        $item->image2 = $request->image2 ?? '';
        $item->slug = $request->slug ?? '';
        $item->corrido = $request->corrido ?? '';
        $item->meta_title = $request->meta_title ?? '';
        $item->meta_description = $request->meta_description ?? '';
        $item->meta_keywords = $request->meta_keywords ?? '';
        $item->save();
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
                $business_settings = Exameall::where('type', $type)->where('product', $id)->first();
            } else {
                $business_settings = Exameall::where('type', $type)->where('product', $id)->first();
            }

            if ($business_settings != null) {
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->product = $id;
                $business_settings->save();
            } else {
                $business_settings = new Exameall;
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->type = $type;
                $business_settings->product = $id;
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->save();
            }
        }

        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        return redirect()->back();
    }
}
