<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Equipeall;
use App\Models\Equipesall;
use Artisan;
use CoreComponentRepository;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\URL;
use Str;

class EquipeallController extends Controller
{

    public function index(Request $request)
    {
        $sort_search = null;
        $query = Equipesall::query();
        if ($request->search != null) {
            $query->where('title', 'like', '%' . $request->search . '%');
            $sort_search = $request->search;
        }
        $items = $query->paginate(15);
        return view('backend.themes.equipeall.' . get_setting('homepage_select') . '.index', compact('items', 'sort_search'));
    }

    public function create()
    {
        $originalItem = Equipesall::first();
        if (!$originalItem) {
            $item = new Equipesall();
            $item->title = Str::random(10);
            $item->slug = Str::slug(Str::random(10));
            $item->save();
            return redirect()->route('equipe.edit', $item->id);
        }
        $item = $originalItem->replicate();
        $item->slug = Str::slug(Str::random(10));
        $item->save();
        return redirect()->route('equipe.edit', $item->id);
    }


    public function edit($id)
    {
        $itemnew = Equipesall::find($id);
        $items = Equipeall::where('theme', get_setting('homepage_select'))->where('product',$itemnew->id)->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = (object) [];
        }
        return view('backend.themes.equipeall.' . get_setting('homepage_select') . '.edit', compact('item','itemnew'));
    }

    public function destroy($id)
    {
        Equipesall::find($id)->delete();
        $relatedServicos = Equipeall::where('product', $id)->get();
        if ($relatedServicos->isNotEmpty()) {
            foreach ($relatedServicos as $relatedServico) {
                $relatedServico->delete();
            }
        }
        return redirect()->back();
    }

    public function general_setting()
    {
        $items = Equipeall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            dd('Nenhum item encontrado');
        }

        return view('backend.themes.equipeall.' . get_setting('homepage_select') . '.edit', compact('item'));
    }

    public function all_servico(){
        $services = Equipesall::all();
        return view("frontend.".get_setting('homepage_select').".servico", compact('services'));
    }

    public function update(Request $request,$id){
        $item = Equipesall::find($id);
        $item->title = $request->title ?? '';
        $item->subtitle = $request->subtitle ?? '';
        $item->image = $request->image ?? '';
        $item->slug = $request->slug ?? '';
        $item->crm = $request->crm ?? '';
        $item->rqe = $request->rqe ?? '';
        $item->meta_title = $request->meta_title ?? '';
        $item->meta_description = $request->meta_description ?? '';
        $item->meta_keywords = $request->meta_keywords ?? '';
        $item->save();
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
                $business_settings = Equipeall::where('type', $type)->where('product', $id)->first();
            } else {
                $business_settings = Equipeall::where('type', $type)->where('product', $id)->first();
            }

            if ($business_settings != null) {
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->product = $id;
                $business_settings->save();
            } else {
                $business_settings = new Equipeall;
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->type = $type;
                $business_settings->product = $id;
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->save();
            }
        }

        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        if ($request->has('tab')) {
            return Redirect::to(URL::previous() . "#" . $request->tab);
        }
        return redirect()->back();
    }
}


