<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Convenio;

class ConvenioController extends Controller {
    public function index(Request $request) {
        $sort_search = null;
        $query = Convenio::query();

        if ($request->search != null) {
            $query->where('title', 'like', '%' . $request->search . '%');
            $sort_search = $request->search;
        }

        $items = $query->paginate(15);
        return view('backend.themes.convenio.index', compact('items', 'sort_search'));
    }

    public function create() {
        $items = Convenio::all();
        return view('backend.themes.convenio.create', compact('items'));
    }

    public function store(Request $request) {
        $item = new Convenio();
        $filteredRequest = array_map(function ($value) {
            return $value === '' ? null : $value;
        }, $request->all());
        $item->fill($filteredRequest);
        $item->save();
        flash(translate('Convenio created successfully'))->success();
        return redirect()->route('convenio.index');
    }

    public function edit($id) {
        $item = Convenio::find($id);
        return view('backend.themes.convenio.edit', compact('item'));
    }

    public function update(Request $request, $id) {
        $item = Convenio::find($id);
        $filteredRequest = array_map(function ($value) {
            return $value === '' ? null : $value;
        }, $request->all());
        $item->fill($filteredRequest);
        $item->save();
        flash(translate('Convenio updated successfully'))->success();
        return redirect()->back();
    }

    public function change_status(Request $request) {
        $item = Convenio::find($request->id);
        $item->status = $request->status;
        $item->save();
        return response()->json(['success' => true]);
    }

    public function destroy($id) {
        Convenio::find($id)->delete();
        return redirect()->back();
    }
}